/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.data.codec.util.AttributeCodecs;
import com.momosoftworks.coldsweat.util.serialization.NbtSerializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class AttributeModifierMap
implements NbtSerializable {
    public static final Codec<AttributeModifierMap> CODEC = Codec.unboundedMap(AttributeCodecs.ATTRIBUTE_CODEC, (Codec)AttributeCodecs.MODIFIER_CODEC.listOf()).xmap(AttributeModifierMap::new, map -> map.getMap().asMap().entrySet().stream().collect(HashMap::new, (mp, ent) -> mp.put((Attribute)ent.getKey(), new ArrayList((Collection)ent.getValue())), HashMap::putAll));
    private final Multimap<Attribute, AttributeModifier> map = HashMultimap.create();

    public AttributeModifierMap() {
    }

    public AttributeModifierMap(Map<Attribute, ?> attributeListMap) {
        attributeListMap.forEach((attribute, list) -> {
            if (list instanceof Collection) {
                this.map.putAll(attribute, (Iterable)((Collection)list));
            } else if (list instanceof AttributeModifier) {
                this.map.put(attribute, (Object)((AttributeModifier)list));
            }
        });
    }

    public AttributeModifierMap(Multimap<Attribute, AttributeModifier> map) {
        this.map.putAll(map);
    }

    public void put(Attribute attribute, AttributeModifier modifier) {
        this.map.put((Object)attribute, (Object)modifier);
    }

    public Collection<AttributeModifier> get(Attribute attribute) {
        return this.map.get((Object)attribute);
    }

    public Multimap<Attribute, AttributeModifier> getMap() {
        return this.map;
    }

    public AttributeModifierMap putAll(AttributeModifierMap other) {
        this.map.putAll(other.map);
        return this;
    }

    public AttributeModifierMap putAll(Attribute attribute, Collection<AttributeModifier> modifiers) {
        this.map.putAll((Object)attribute, modifiers);
        return this;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        this.map.asMap().forEach((attribute, modifier) -> {
            String key = ForgeRegistries.ATTRIBUTES.getKey(attribute).toString();
            ListTag list = new ListTag();
            modifier.forEach(mod -> list.add((Object)mod.m_22219_()));
            tag.m_128365_(key, (Tag)list);
        });
        return tag;
    }

    public static AttributeModifierMap deserialize(CompoundTag tag) {
        if (tag.m_128456_()) {
            return new AttributeModifierMap();
        }
        HashMultimap map = HashMultimap.create();
        tag.m_128431_().forEach(arg_0 -> AttributeModifierMap.lambda$deserialize$6(tag, (Multimap)map, arg_0));
        return new AttributeModifierMap((Multimap<Attribute, AttributeModifier>)map);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeModifierMap that = (AttributeModifierMap)obj;
        return this.map.equals(that.map);
    }

    private static /* synthetic */ void lambda$deserialize$6(CompoundTag tag, Multimap map, String key) {
        Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(key));
        ListTag list = tag.m_128437_(key, 10);
        list.forEach(mod -> map.put((Object)attribute, (Object)AttributeModifier.m_22212_((CompoundTag)((CompoundTag)mod))));
    }
}

